{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 13.10.98 - 19:03:31 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDSPObj, MMUtils, MMWave, MMGauge, MMPCMSup, MMCstDlg;
  
type
  TForm1 = class(TForm)
    SrcFile: TMMWaveFile;
    DstFile: TMMWaveFile;
    Button1: TButton;
    Gauge: TMMGauge;
    Label1: TLabel;
    Label2: TLabel;
    OpenDialog: TMMWaveOpenDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    function NormalizeFile(const FileName: string): Boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ This Demo normalizes a wave file }
function TForm1.NormalizeFile(const FileName: string): Boolean;
var
   i: integer;
   nRead,nBytes,dwPos: Longint;
   Buf: array[0..4096-1] of Char;
   PeakL,PeakR,Peak,S,MaxVal: Smallint;
   Gain: Extended;
   Dst: string;

begin
   Result := False;

   SrcFile.Wave.FileName := FileName;

   { only PCM format is supported }
   if (SrcFile.Wave.FormatTag <> 1) then exit;

   SrcFile.Wave.OpenFile;

   Screen.Cursor := crHourglass;

   Gauge.Visible := True;

   { Peak search }
   Peak := 0;
   dwPos := 0;
   nBytes := SrcFile.Wave.DataSize;
   while (nBytes > 0) do
   begin
      nRead := Min(nBytes,sizeOf(Buf));
      nRead := SrcFile.Wave.ReadDataBytes(@Buf,nRead);

      pcmFindPeak(SrcFile.Wave.PWaveFormat, @Buf, nRead, PeakL, PeakR);
      if abs(PeakL) > abs(Peak) then Peak := PeakL;
      if abs(PeakR) > abs(Peak) then Peak := PeakR;

      dec(nBytes,nRead);
      inc(dwPos,nRead);
      Gauge.Progress := Round((dwPos*100.0)/SrcFile.Wave.DataSize);
   end;

   Label2.Caption := IntToStr(Peak);
   Label2.Update;

   if (SrcFile.Wave.BitLength = 8) then
   begin
      Peak  := abs(Peak)-127;
      MaxVal:= 127;
   end
   else
   begin
      Peak  := abs(Peak);
      MaxVal:= 32767;
   end;

   if Peak < MaxVal then
   begin
      Gain := MaxVal/Peak;

      SrcFile.Wave.Position := 0;
      Dst := ChangeFileExt(SrcFile.Wave.FileName,'.TMP');
      DstFile.Wave.CreateFile(Dst,SrcFile.PWaveFormat);
      Gauge.Caption := 'Normalize...';

      { normalize }
      nBytes := SrcFile.Wave.DataSize;
      dwPos := 0;
      while (nBytes > 0) do
      begin
         nRead := Min(nBytes,sizeOf(Buf));
         nRead := SrcFile.Wave.ReadDataBytes(@Buf,nRead);

         if (SrcFile.Wave.BitLength = 8) then
         begin
            for i := 0 to nRead-1 do
            begin
               S := PByteArray(@Buf)^[i];
               PByteArray(@Buf)^[i] := MinMax(Round((S-128)*Gain)+128,0,256);
            end;
         end
         else
         begin
            for i := 0 to (nRead div 2)-1 do
            begin
               S := PSmallArray(@Buf)^[i];
               PSmallArray(@Buf)^[i] := MinMax(Round(S*Gain),-32768,32767);
            end;
         end;

         DstFile.Wave.WriteDataBytes(@Buf,nRead);

         dec(nBytes,nRead);
         inc(dwPos,nRead);
         Gauge.Progress := Round((dwPos*100.0)/SrcFile.Wave.DataSize);
      end;
   end;

   Result := True;

   SrcFile.Wave.CloseFile;
   DstFile.Wave.CloseFile;


   Gauge.Visible := False;

   if Result then
   begin
      DeleteFile(FileName);
      RenameFile(Dst, FileName);
   end
   else
   begin
      DeleteFile(Dst);
   end;

   Screen.Cursor := crDefault;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   if OpenDialog.Execute then
      NormalizeFile(OpenDialog.FileName);
end;

end.
